<?php

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Freshio_Image_Running extends Elementor\Widget_Base {

    public function get_name() {
        return 'freshio-image-running';
    }

    public function get_title() {
        return __('Freshio Image Running', 'freshio');
    }

    public function get_icon() {
        return 'eicon-slider-push';
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_image_content',
            [
                'label' => __('Image', 'freshio'),
            ]
        );

        $this->add_control(
            'carousel',
            [
                'label'      => __('Add Images', 'freshio'),
                'type'       => Controls_Manager::GALLERY,
                'default'    => [],
                'show_label' => false,
                'dynamic'    => [
                    'active' => true,
                ],
            ]
        );

        $this->add_responsive_control(
            'item_spacing',
            [
                'label'      => __('Spacing', 'freshio'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .image-wrapper .row'         => 'margin-left: calc(-{{SIZE}}{{UNIT}}/2); margin-right: calc(-{{SIZE}}{{UNIT}}/2);',
                    '{{WRAPPER}} .image-wrapper .column-item' => 'padding-left: calc({{SIZE}}{{UNIT}}/2); padding-right: calc({{SIZE}}{{UNIT}}/2); margin-bottom: calc({{SIZE}}{{UNIT}});',
                    '{{WRAPPER}} .image-wrapper img + img'    => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="image-wrapper">
            <div <?php echo freshio_elementor_get_render_attribute_string('row', $this); ?>>
                <div class="tech-slideshow">
                    <?php
                    foreach ($settings['carousel'] as $index => $attachment) { ?>
                        <img class="image-carousel" src="<?php echo esc_url($attachment['url']) ?>" alt=""/>
                    <?php } ?>
                    <div class="mover-1"></div>
<!--                    <div class="mover-2"></div>-->
                </div>
            </div>
        </div>
        <?php

    }

}

$widgets_manager->register(new Freshio_Image_Running());
